---
title: Configuration
---

# Configuration

<div class="documentation__toc"></div>

## Introduction

The Forum comes configured in such a way that it's ready to use.

### Settings Module

Many of these configurations are `bound` to settings and can be controlled from the Control Panel.

[Settings Module](/documentation/settings-module){.link}

## Forum

### Filters

Define `filters` and their query handlers for the forum.

```php
'filters' => [
    'mine'          => [
        'user'  => true,
        'title' => 'anomaly.module.forum::filter.mine',
        'query' => \Anomaly\ForumModule\Discussion\Filter\FilterMine::class,
    ],
    'participating' => [
        'user'  => true,
        'title' => 'anomaly.module.forum::filter.participating',
        'query' => \Anomaly\ForumModule\Discussion\Filter\FilterParticipating::class,
    ],
    'following'     => [
        'title' => 'anomaly.module.forum::filter.following',
        'query' => \Anomaly\ForumModule\Discussion\Filter\FilterFollowing::class,
    ],
    'trending'      => [
        'title' => 'anomaly.module.forum::filter.trending',
        'query' => \Anomaly\ForumModule\Discussion\Filter\FilterTrending::class,
    ],
    'popular'       => [
        'title' => 'anomaly.module.forum::filter.popular',
        'query' => \Anomaly\ForumModule\Discussion\Filter\FilterPopular::class,
    ],
    'answered'      => [
        'title' => 'anomaly.module.forum::filter.answered',
        'query' => \Anomaly\ForumModule\Discussion\Filter\FilterAnswered::class,
    ],
    'unanswered'    => [
        'title' => 'anomaly.module.forum::filter.unanswered',
        'query' => \Anomaly\ForumModule\Discussion\Filter\FilterUnanswered::class,
    ],
    'no_replies'    => [
        'title' => 'anomaly.module.forum::filter.no_replies',
        'query' => \Anomaly\ForumModule\Discussion\Filter\FilterNoReplies::class,
    ],
],
```

```php
config(['anomaly.module.forum::forum.filters' => $filters]);
```


## Notifications

### New Discussions

The `new_discussion` configuration defines the emails to send notifications to when a new discussion is posted.

```php
'new_discussion' => [
    'exmaple@domain.com',
],
```

```php
config(['anomaly.module.forum::notifications.new_discussion' => $recipients]);
```
