---
title: Forum
---

# Forum

<div class="documentation__toc"></div>

## Introduction

Forum are the primary components of your structured content. Every page has a type that defines it's available fields and layout.


#### Fields

Below is a list of `fields` in the `forum` stream not including custom fields.

Fields are accessed as attributes:

    $page->title;

Same goes for decorated instances in Twig:

    {{ page.title }}

Note that _active_ forum get pushed into the template super variable:

    {{ template.page.title }}

###### Fields

<table class="table table-bordered table-striped">

<thead>

<tr>

<th>Key</th>

<th>Type</th>

<th>Description</th>

</tr>

</thead>

<tbody>

<tr>

<td>

title

</td>

<td>

text

</td>

<td>

The display title.

</td>

</tr>

<tr>

<td>

slug

</td>

<td>

slug

</td>

<td>

The path slug.

</td>

</tr>

<tr>

<td>

meta_title

</td>

<td>

text

</td>

<td>

The meta title falls back to the page title.

</td>

</tr>

<tr>

<td>

meta_description

</td>

<td>

textarea

</td>

<td>

The meta description.

</td>

</tr>

<tr>

<td>

meta_keywords

</td>

<td>

tags

</td>

<td>

The meta keywords.

</td>

</tr>

<tr>

<td>

enabled

</td>

<td>

boolean

</td>

<td>

Whether the page is enabled or not.

</td>

</tr>

<tr>

<td>

home

</td>

<td>

boolean

</td>

<td>

Whether the page is the home page or not.

</td>

</tr>

<tr>

<td>

visible

</td>

<td>

boolean

</td>

<td>

Whether to display the page in `structure()` navigation or not.

</td>

</tr>

<tr>

<td>

exact

</td>

<td>

boolean

</td>

<td>

Whether to require an exact URI match or not.

</td>

</tr>

<tr>

<td>

allowed_roles

</td>

<td>

multiple

</td>

<td>

The user roles allowed to view the page.

</td>

</tr>

<tr>

<td>

theme_layout

</td>

<td>

select

</td>

<td>

The theme layout to override the value defined in the page's type.

</td>

</tr>

</tbody>

</table>

