---
title: Types
---

# Types

<div class="documentation__toc"></div>

## Introduction

Page `types` are allow you to define custom fields and layout for forum _of this type_.


#### Fields

Below is a list of `fields` in the `types` stream. Fields are accessed as attributes:

    $type->name;

Same goes for decorated instances in Twig:

    {{ type.name }}

###### Fields

<table class="table table-bordered table-striped">

<thead>

<tr>

<th>Key</th>

<th>Type</th>

<th>Description</th>

</tr>

</thead>

<tbody>

<tr>

<td>

name

</td>

<td>

text

</td>

<td>

The type name.

</td>

</tr>

<tr>

<td>

description

</td>

<td>

textarea

</td>

<td>

The type description.

</td>

</tr>

<tr>

<td>

slug

</td>

<td>

slug

</td>

<td>

The slug used for API and database table.

</td>

</tr>

<tr>

<td>

handler

</td>

<td>

addon

</td>

<td>

The page handler extension to use.

</td>

</tr>

<tr>

<td>

theme_layout

</td>

<td>

select

</td>

<td>

The default theme layout for forum of this type.

</td>

</tr>

<tr>

<td>

layout

</td>

<td>

editor

</td>

<td>

The layout of the custom page fields.

</td>

</tr>

</tbody>

</table>


#### Theme Layouts

The type's theme layout will define the defualt theme layout to wrap the page's content.

Theme layouts generally specify the top level structural layout of your website. Perhaps a layout for your home page specifically, one for two column forum, and perhaps one custom HTML forum.


##### Accessing Active Forum

You can access the active page in theme layouts if needed by using the `template` super variable.

    {{ template.page.title }}

A more realistic example might look like this:

    {% if template.page.banner_image.id %}
        <div id="banner" style="background-image: url({{ template.page.banner_image.path }});">
            ...
        </div>
    {% endif %}


#### Page Layouts

The type's page layout is wrapped by the theme layout.

The primary goal of the page layout is to display the page's custom field values.


##### Defining Page Layouts

When defining the page layout the `page` is available to access field values.

In the simple example below `content` is the field slug of the WYSIWYG field assigned to this page's type.

    <h1>{{ page.title }}</1h>

    {{ page.content.render|raw }}

A more powerful example using our [Grid field type](/documentation/grid-field-type) with the field slug `content` might look like this:

    {% for section in page.content %}
        <div class="section {{ section.type }}-section-type">
            {% include "theme::sections/" ~ section.type %}
        </div>
    {% endfor %}

The above example will let you define well designed and controlled content section that allow the user to easily build structured stacks of content.

