---
title: Upgrade Guide
---

# Upgrade Guide

<div class="documentation__toc"></div>

## Upgrading to 2.2.0 From 1.1

**Estimated Upgrade Time: 10 - 15 Minutes**

> We attempt to document every possible change. Since some of these changes are in obscure parts of the API only a portion of these changes may actually affect your application.{.notice}

## Backup Forum

The first thing we want to do is backup the forum tables. The following tables should be backed up as SQL with values only. No table structure - data only.
 
- `forum_channels`
- `forum_channels_translations`
- `forum_comments`
- `forum_discussions`
- `forum_participation`

## Update Constraint

Next update your composer constraints to something along the lines of `"anomaly/forum-module": "~2.2.0"` or the likes and run `composer update`.

## Reinstall

Next, simply reinstall the addon without the `seed` option.

```bash
php artisan addon:reinstall forum
```

## Modify Schema

Next, we need to make a couple small modifications to the new schema so that our import works. 

### Comments

Add an `int` column called `user_id` to the `forum_comments` table.

### Participation

Add a `varchar (255)` column called `subscription` to the `forum_participation` table.

## Import

Next import the exported data we did in the first step.

## Update Counts

Add the following to your `routes/console.php` file:

```php
Artisan::command(
    'forum:update',
    function (\Anomaly\ForumModule\Discussion\Contract\DiscussionRepositoryInterface $discussions) {
        foreach ($discussions->all() as $discussion) {

            $discussion->setAttribute('view_count', $discussion->participants->count());
            $discussion->setAttribute('comment_count', $discussion->comments->count());

            $discussion->save();

            $this->info("Updated discussion [{$discussion->getId()}]");
        }
    }
);
```

Then run `php artisan forum:update`. You can remove this code when it fiishes. 

## Finishing Up

Next run the following queries to update defaults in existing data:
 
```mysql
UPDATE {application}_forum_participation SET following = true WHERE subscription = 'follow'
```

```mysql
UPDATE {application}_forum_discussions SET approved = true
```

```mysql
UPDATE {application}_forum_comments SET approved = true
```

