<?php namespace Visiosoft\ForumModule\Discussion\Event;

use Visiosoft\ForumModule\Discussion\Contract\DiscussionInterface;

class DiscussionWasCreated
{

    /**
     * The discussion instance.
     *
     * @var DiscussionInterface
     */
    protected $discussion;

    /**
     * Create a new DiscussionWasCreated instance.
     *
     * @param DiscussionInterface $discussion
     */
    public function __construct(DiscussionInterface $discussion)
    {
        $this->discussion = $discussion;
    }

    /**
     * Get the discussion.
     *
     * @return DiscussionInterface
     */
    public function getDiscussion()
    {
        return $this->discussion;
    }
}
