<?php namespace Visiosoft\ForumModule\Participation\Command;

use Visiosoft\ForumModule\Comment\Contract\CommentInterface;
use Visiosoft\ForumModule\Comment\Notification\CommentWasPosted;
use Visiosoft\ForumModule\Participation\Contract\ParticipationInterface;
use Anomaly\Streams\Platform\User\Contract\UserInterface;
use Illuminate\Notifications\Notifiable;

class NotifyFollowers
{

    /**
     * The comment instance.
     *
     * @var CommentInterface
     */
    protected $comment;

    /**
     * Create a new NotifyFollowers instance.
     *
     * @param CommentInterface $comment
     */
    public function __construct(CommentInterface $comment)
    {
        $this->comment = $comment;
    }

    /**
     * Handle the command.
     */
    public function handle()
    {

        $discussion = $this->comment->getDiscussion();

        /* @var ParticipationInterface $participant */
        foreach ($discussion->getFollowers() as $follower) {

            if ($follower->getUserId() == $this->comment->getCreatedById()) {
                continue;
            }

            /* @var UserInterface|Notifiable $user */
            $user = $follower->getUser();

            if ($this->comment->mentions($user)) {
                continue; // They already have a notification.
            }

            $user->notify(new CommentWasPosted($this->comment));
        }
    }
}
