<?php namespace Visiosoft\ForumModule\Discussion;

use Visiosoft\ForumModule\Channel\Contract\ChannelInterface;
use Visiosoft\ForumModule\Discussion\Contract\DiscussionInterface;
use Visiosoft\ForumModule\Discussion\Contract\DiscussionRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class DiscussionRepository extends EntryRepository implements DiscussionRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var DiscussionModel
     */
    protected $model;

    /**
     * Create a new DiscussionRepository instance.
     *
     * @param DiscussionModel $model
     */
    public function __construct(DiscussionModel $model)
    {
        $this->model = $model;
    }

    /**
     * Get recent discussions.
     *
     * @return DiscussionCollection
     */
    public function getRecent($limit = null)
    {
        return $this->model
            ->orderBy('created_at', 'DESC')
            ->take($limit)
            ->get();
    }

    /**
     * Find a discussion by slug.
     *
     * @param $slug
     * @return DiscussionInterface
     */
    public function findBySlug($slug)
    {
        return $this->model->where('slug', $slug)->first();
    }

    /**
     * Find many discussions by channel.
     *
     * @param ChannelInterface $channel
     * @param $limit
     * @return DiscussionCollection
     */
    public function findManyByChannel(ChannelInterface $channel, $limit)
    {
        return $this->model
            ->where('channel_id', $channel->getId())
            ->take($limit)
            ->get();
    }
}
