<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleForumCreateCommentsStream extends Migration
{

    /**
     * Delete this stream when resetting.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug'       => 'comments',
        'searchable' => true,
        'trashable'  => true,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'content'    => [
            'required' => true,
        ],
        'discussion' => [
            'required' => true,
        ],
        'ip_address' => [
            'required' => true,
        ],
        'flagged',
        'flagged_by',
        'approved',
        'approved_by',
    ];
}
