<?php namespace Visiosoft\ForumModule\Discussion\Command;

use Visiosoft\ForumModule\Discussion\Contract\DiscussionInterface;
use Visiosoft\ForumModule\Participation\Contract\ParticipationInterface;
use Visiosoft\ForumModule\Participation\Contract\ParticipationRepositoryInterface;
use Anomaly\Streams\Platform\Model\EloquentModel;
use Anomaly\Streams\Platform\User\Contract\UserInterface;
use Illuminate\Contracts\Auth\Guard;

class UpdateParticipation
{

    /**
     * The discussion interface.
     *
     * @var DiscussionInterface
     */
    protected $discussion;

    /**
     * The update attributes.
     *
     * @var array
     */
    protected $attributes;

    /**
     * Create a new SetMetaInformation instance.
     *
     * @param DiscussionInterface $discussion
     * @param array $attributes
     */
    public function __construct(DiscussionInterface $discussion, array $attributes = [])
    {
        $this->attributes = $attributes;
        $this->discussion = $discussion;
    }

    /**
     * Handle the command.
     *
     * @param ParticipationRepositoryInterface $participation
     * @param Guard $auth
     */
    public function handle(ParticipationRepositoryInterface $participation, Guard $auth)
    {
        /* @var UserInterface $user */
        if (!$user = array_get($this->attributes, 'user', $auth->user())) {
            return;
        }

        /* @var ParticipationInterface|EloquentModel $participant */
        if (!$participant = $participation->findByDiscussionAndUser($this->discussion, $user)) {
            $participation->withoutEvents(
                function () use ($participation, $user) {
                    $participation->create(
                        array_merge(
                            [
                                'discussion' => $this->discussion,
                                'user'       => $user,
                                'read_at'    => time(),
                            ],
                            $this->attributes
                        )
                    );
                }
            );

            return;
        }

        $participant->fill(array_merge($this->attributes, ['read_at' => 'now']));

        $participation->withoutEvents(
            function () use ($participation, $participant) {
                $participation->save($participant);
            }
        );
    }
}
