<?php namespace Visiosoft\ForumModule\Discussion\Command;

use Visiosoft\ForumModule\Discussion\Contract\DiscussionInterface;
use Illuminate\Http\Request;

class SetIpAddress
{

    /**
     * The discussion instance.
     *
     * @var DiscussionInterface
     */
    protected $discussion;

    /**
     * Create a new SetIpAddress instance.
     *
     * @param DiscussionInterface $discussion
     */
    public function __construct(DiscussionInterface $discussion)
    {
        $this->discussion = $discussion;
    }

    /**
     * Handle the command.
     *
     * @param Request $request
     */
    public function handle(Request $request)
    {
        $this->discussion->setAttribute('ip_address', $request->getClientIp());
    }
}
