<?php namespace Visiosoft\ForumModule\Comment;

use Visiosoft\ForumModule\Comment\Contract\CommentInterface;
use Visiosoft\ForumModule\Discussion\Contract\DiscussionInterface;
use Visiosoft\ForumModule\Mention\MentionParser;
use Anomaly\Streams\Platform\Model\Forum\ForumCommentsEntryModel;
use Anomaly\Streams\Platform\User\Contract\UserInterface;

/**
 * Class CommentModel
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class CommentModel extends ForumCommentsEntryModel implements CommentInterface
{

    /**
     * Return mentioned usernames.
     * OR if provided user is mentioned.
     *
     * @param UserInterface $user
     * @return array|bool
     */
    public function mentions(UserInterface $user = null)
    {
        /* @var MentionParser $parser */
        $parser = app(MentionParser::class);

        $usernames = $parser->parse($this->getContent());

        if ($user instanceof UserInterface) {
            return in_array($user->getUsername(), $usernames);
        }

        return $usernames;
    }

    /**
     * Return the flagged flag.
     *
     * @return bool
     */
    public function isFlagged()
    {
        return $this->flagged;
    }

    /**
     * Return the liked flag.
     *
     * @return bool
     */
    public function isLiked()
    {
        return (bool)$this
            ->reactions()
            ->select('id')
            ->whereType('thumbsup')
            ->whereUserId(auth()->id())
            ->first();
    }

    /**
     * Get the created by username.
     *
     * @return string
     */
    public function getCreatedByUsername()
    {
        return $this
            ->getCreatedBy()
            ->getUsername();
    }

    /**
     * Get the created by ID.
     *
     * @return int
     */
    public function getCreatedById()
    {
        return $this->created_by_id;
    }

    /**
     * Get the content.
     *
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * Get the related discussion title.
     *
     * @return string
     */
    public function getDiscussionTitle()
    {
        $discussion = $this->getDiscussion();

        return $discussion->getTitle();
    }

    /**
     * Get the related discussion.
     *
     * @return DiscussionInterface
     */
    public function getDiscussion()
    {
        return $this->discussion;
    }

    /**
     * Return routable array.
     *
     * @return array
     */
    public function toRoutableArray()
    {
        $discussion = $this->getDiscussion();
        $channel    = $discussion->getChannel();

        $routable = parent::toRoutableArray();

        $routable['channel']    = $channel->getSlug();
        $routable['discussion'] = $discussion->getSlug();

        return $routable;
    }
}
