<?php namespace Visiosoft\ForumModule\Comment\Command;

use Visiosoft\ForumModule\Comment\Contract\CommentInterface;
use Visiosoft\ForumModule\Participation\Contract\ParticipationRepositoryInterface;
use Anomaly\ReactionsExtension\Reaction\Contract\ReactionInterface;
use Anomaly\ReactionsExtension\Reaction\Contract\ReactionRepositoryInterface;
use Anomaly\Streams\Platform\Model\EloquentModel;
use Anomaly\Streams\Platform\User\Contract\UserInterface;
use Illuminate\Contracts\Auth\Guard;

class UnlikeComment
{

    /**
     * The comment interface.
     *
     * @var CommentInterface
     */
    protected $comment;

    /**
     * The user instance.
     *
     * @var UserInterface
     */
    protected $user;

    /**
     * Create a new UnlikeComment instance.
     *
     * @param CommentInterface $comment
     * @param UserInterface|null $user
     */
    public function __construct(CommentInterface $comment, UserInterFace $user = null)
    {
        $this->user    = $user;
        $this->comment = $comment;
    }

    /**
     * Handle the command.
     *
     * @param ParticipationRepositoryInterface $participation
     * @param Guard $auth
     * @return bool
     * @throws \Exception
     */
    public function handle(ReactionRepositoryInterface $reactions, Guard $auth)
    {
        /* @var UserInterface $user */
        if (!$this->user = $this->user ?: $auth->user()) {
            throw new \Exception('You must be logged in to unlike a comment.');
        }

        /* @var ReactionInterface|EloquentModel $reaction */
        if ($reaction = $reactions->findReaction('thumbsup', $this->comment, $this->user)) {
            return (bool)$reactions->delete($reaction);
        }

        return true;
    }
}
