<?php namespace Visiosoft\ForumModule\Discussion\Command;

use Visiosoft\ForumModule\Discussion\Contract\DiscussionInterface;
use Visiosoft\ForumModule\Mention\Contract\MentionRepositoryInterface;
use Visiosoft\ForumModule\Mention\MentionManager;
use Visiosoft\ForumModule\Mention\MentionParser;
use Anomaly\Streams\Platform\User\Contract\UserInterface;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Notifications\Notifiable;

class HandleMentions
{

    /**
     * The discussion instance.
     *
     * @var DiscussionInterface
     */
    protected $discussion;

    /**
     * Create a new SetApproval instance.
     *
     * @param DiscussionInterface $discussion
     */
    public function __construct(DiscussionInterface $discussion)
    {
        $this->discussion = $discussion;
    }

    /**
     * Handle the command.
     *
     * @param MentionParser $parser
     * @param UserRepositoryInterface $users
     */
    public function handle(
        UserRepositoryInterface $users,
        MentionManager $mentions,
        MentionParser $parser
    ) {
        foreach ($parser->parse($this->discussion->getContent()) as $mention) {

            /* @var Notifiable|UserInterface $user */
            if (!$user = $users->findByUsername($mention)) {
                continue;
            }

            $mentions->send($user, $this->discussion);
        }
    }
}
