<?php namespace Visiosoft\ForumModule\Comment;

use Visiosoft\ForumModule\Comment\Command\FlagComment;
use Visiosoft\ForumModule\Comment\Command\LikeComment;
use Visiosoft\ForumModule\Comment\Command\UnflagComment;
use Visiosoft\ForumModule\Comment\Command\UnlikeComment;
use Visiosoft\ForumModule\Comment\Contract\CommentInterface;
use Anomaly\Streams\Platform\User\Contract\UserInterface;

/**
 * Class CommentManager
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class CommentManager
{

    /**
     * Flag a comment.
     *
     * @param CommentInterface $comment
     * @return bool
     */
    public function flag(CommentInterface $comment)
    {
        return dispatch_now(new FlagComment($comment));
    }

    /**
     * Unflag a comment.
     *
     * @param CommentInterface $comment
     * @return bool
     */
    public function unflag(CommentInterface $comment)
    {
        return dispatch_now(new UnflagComment($comment));
    }

    /**
     * Like a comment.
     *
     * @param CommentInterface $comment
     * @param UserInterface|null $user
     * @return bool
     */
    public function like(CommentInterface $comment, UserInterface $user = null)
    {
        return dispatch_now(new LikeComment($comment, $user));
    }

    /**
     * Unlike a comment.
     *
     * @param CommentInterface $comment
     * @param UserInterface|null $user
     * @return bool
     */
    public function unlike(CommentInterface $comment, UserInterface $user = null)
    {
        return dispatch_now(new UnlikeComment($comment, $user));
    }
}
