<?php namespace Visiosoft\ForumModule\Participation\Contract;

use Visiosoft\ForumModule\Discussion\Contract\DiscussionInterface;
use Visiosoft\ForumModule\Participation\ParticipationCollection;
use Anomaly\Streams\Platform\Entry\Contract\EntryRepositoryInterface;
use Anomaly\Streams\Platform\User\Contract\UserInterface;


interface ParticipationRepositoryInterface extends EntryRepositoryInterface
{

    /**
     * Find all participants by discussion.
     *
     * @param DiscussionInterface $discussion
     * @return ParticipationCollection
     */
    public function findAllByDiscussion(DiscussionInterface $discussion);

    /**
     * Find a participant by discussion and user.
     *
     * @param DiscussionInterface $discussion
     * @param UserInterface $user
     * @return ParticipationInterface|null
     */
    public function findByDiscussionAndUser(DiscussionInterface $discussion, UserInterface $user);
}
