<?php namespace Visiosoft\ForumModule\Http\Controller\Admin;

use Visiosoft\ForumModule\Channel\Contract\ChannelInterface;
use Visiosoft\ForumModule\Channel\Contract\ChannelRepositoryInterface;
use Visiosoft\ForumModule\Channel\Form\ChannelFormBuilder;
use Visiosoft\ForumModule\Channel\Table\ChannelTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class ChannelsController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param  ChannelTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(ChannelTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param  ChannelFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(ChannelFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param  ChannelFormBuilder $form
     * @param                                             $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(ChannelFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    /**
     * Redirect to a channel page.
     *
     * @param  ChannelRepositoryInterface $channels
     * @param                                    $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function view(ChannelRepositoryInterface $channels, $id)
    {
        /* @var ChannelInterface $channel */
        $channel = $channels->find($id);

        return $this->redirect->to($channel->route('view'));
    }
}
