<?php namespace Visiosoft\ForumModule\Discussion\Table;

use Visiosoft\ForumModule\Discussion\Table\View\FlaggedQuery;
use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class DiscussionTableBuilder extends TableBuilder
{

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [
        'all',
        'flagged' => [
            'query' => FlaggedQuery::class,
        ],
        'trash',
    ];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [
        'search' => [
            'fields' => [
                'title',
                'content',
            ],
        ],
        'channel',
    ];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'title',
        'channel',
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'edit',
        'view' => [
            'target' => '_blank',
        ],
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete',
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [
        'order_by' => [
            'created_at' => 'DESC',
        ],
    ];
}
