<?php namespace Visiosoft\ForumModule\Discussion\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;

class DiscussionFormBuilder extends FormBuilder
{

    /**
     * Fields to skip.
     *
     * @var array|string
     */
    protected $skips = [
        'slug',
        'author',
        'ip_address',
        'flagged',
        'flagged_by',
        'answer',
        'locked',
        'locked_by',
        'pinned',
        'pinned_by',
    ];

    protected $fields = [
        'channel' => [
            'config' => [
                'default_value' => '{request.input.channel}',
            ],
        ],
        'title',
        'content',
    ];

    /**
     * The form actions.
     *
     * @var array
     */
    protected $actions = [
        'submit',
    ];

    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [
        'success_message' => false,
    ];

    /**
     * The form assets.
     *
     * @var array
     */
    protected $assets = [
        'styles.css' => [
            'visiosoft.module.forum::css/jquery.atwho.min.css',
        ],
        'scripts.js' => [
            'visiosoft.module.forum::js/jquery.caret.min.js',
            'visiosoft.module.forum::js/jquery.atwho.min.js',
            'visiosoft.module.forum::js/mention.js',
        ],
    ];
}
