<?php namespace Visiosoft\ForumModule\Discussion\Command;

use Visiosoft\ForumModule\Discussion\Contract\DiscussionInterface;
use Visiosoft\ForumModule\Discussion\Notification\DiscussionWasCreated;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\AnonymousNotifiable;
use Illuminate\Queue\InteractsWithQueue;

class SendNotifications implements ShouldQueue
{

    use InteractsWithQueue;

    /**
     * The discussion instance.
     *
     * @var DiscussionInterface
     */
    protected $discussion;

    /**
     * Create a new SetApproval instance.
     *
     * @param DiscussionInterface $discussion
     */
    public function __construct(DiscussionInterface $discussion)
    {
        $this->discussion = $discussion;
    }

    /**
     * Handle the command.
     */
    public function handle()
    {
        if (!$recipients = (array)config('visiosoft.module.forum::notifications.new_discussion')) {
            return;
        }

        (new AnonymousNotifiable())
            ->route('mail', $recipients)
            ->notify(new DiscussionWasCreated($this->discussion));
    }
}
