<?php namespace Visiosoft\ForumModule\Discussion\Command;

use Visiosoft\ForumModule\Discussion\Contract\DiscussionInterface;
use Visiosoft\ForumModule\Discussion\Contract\DiscussionRepositoryInterface;
use Anomaly\Streams\Platform\Model\EloquentModel;

class IncrementViewCount
{

    /**
     * The discussion interface.
     *
     * @var DiscussionInterface|EloquentModel
     */
    protected $discussion;

    /**
     * Create a new SetMetaInformation instance.
     *
     * @param DiscussionInterface $discussion
     */
    public function __construct(DiscussionInterface $discussion)
    {
        $this->discussion = $discussion;
    }

    /**
     * Handle the command.
     *
     * @param DiscussionRepositoryInterface $discussions
     */
    public function handle(DiscussionRepositoryInterface $discussions)
    {
        $discussions->withoutEvents(function() use ($discussions) {
            $discussions->save($this->discussion->setAttribute('view_count', $this->discussion->getViewCount() + 1));
        });
    }
}
