<?php namespace Visiosoft\ForumModule\Channel;

use Visiosoft\ForumModule\Channel\Contract\ChannelRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;

class ChannelSeeder extends Seeder
{

    /**
     * The channel repository.
     *
     * @var ChannelRepositoryInterface
     */
    protected $channels;

    /**
     * Create a new ChannelSeeder instance.
     *
     * @param ChannelRepositoryInterface $channels
     */
    public function __construct(ChannelRepositoryInterface $channels)
    {
        $this->channels = $channels;

        parent::__construct();
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        $this->channels->create(
            [
                'en'   => [
                    'name'        => 'Everything',
                    'description' => 'Discuss anything and everything.',
                ],
                'slug' => 'everything',
            ]
        );
    }
}
