<?php namespace Visiosoft\ForumModule\Channel;

use Visiosoft\ForumModule\Channel\Contract\ChannelInterface;
use Visiosoft\ForumModule\Channel\Contract\ChannelRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

/**
 * Class ChannelRepository
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class ChannelRepository extends EntryRepository implements ChannelRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var ChannelModel
     */
    protected $model;

    /**
     * Create a new ChannelRepository instance.
     *
     * @param ChannelModel $model
     */
    public function __construct(ChannelModel $model)
    {
        $this->model = $model;
    }

    /**
     * Find a channel by it's slug.
     *
     * @param $slug
     * @return ChannelInterface|null
     */
    public function findBySlug($slug)
    {
        return $this->model->where('slug', $slug)->first();
    }
}
