<?php namespace Visiosoft\ForumModule\Channel;

use Visiosoft\ForumModule\Channel\Contract\ChannelInterface;
use Anomaly\Streams\Platform\Support\Authorizer;
use Anomaly\Streams\Platform\User\Contract\UserInterface;
use Anomaly\UsersModule\Role\RoleCollection;

/**
 * Class ChannelAuthorizer
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class ChannelAuthorizer
{

    /**
     * The authorizer utility.
     *
     * @var Authorizer
     */
    protected $authorizer;

    /**
     * Create a new ChannelAuthorizer instance.
     *
     * @param Authorizer $authorizer
     */
    public function __construct(Authorizer $authorizer)
    {
        $this->authorizer = $authorizer;
    }

    /**
     * Authorize the page.
     *
     * @param ChannelInterface $channel
     * @return bool|\Illuminate\Http\RedirectResponse
     */
    public function authorize(ChannelInterface $channel)
    {
        /* @var UserInterface $user */
        $user = auth()->user();

        /**
         * Admins are no question.
         */
        if ($user && $user->isAdmin()) {
            return true;
        }

        /* @var RoleCollection $allowed */
        $allowed = $channel->getAllowedRoles();

        /**
         * No roles? No problem.
         */
        if ($allowed->isEmpty()) {
            return true;
        }

        /**
         * Make sure we have the
         * user at this point.
         */
        if (!$user) {
            return redirect()->guest(route('anomaly.module.users::login'));
        }

        /**
         * If you flat out don't have
         * access then abort to 403.
         */
        if (!$user->hasAnyRole($allowed)) {
            abort(403);
        }

        return true;
    }
}
