(function (window, document) {

    /**
     * Handle toggling likes.
     */
    let likes = Array.prototype.slice.call(
        document.querySelectorAll('[data-like]')
    );

    likes.forEach(function (like) {

        like.addEventListener('click', function (event) {

            event.preventDefault();

            let count = like.querySelector('[data-count]');

            let request = new XMLHttpRequest();

            if (like.classList.contains(like.dataset.toggle)) {
                request.open('POST', like.dataset.unlike, true);

                if (count) {

                    let total = Number(like.innerText) - 1;

                    count.innerText = total ? total : '';
                }
            } else {
                request.open('POST', like.dataset.like, true);

                if (count) {
                    count.innerText = Number(like.innerText) + 1;
                }
            }

            request.setRequestHeader('Content-Type', 'application/json');

            request.send(JSON.stringify({
                _token: CSRF_TOKEN
            }));

            like.classList.toggle(like.dataset.toggle);
        });
    });


    /**
     * Handle following likes.
     */
    let follows = Array.prototype.slice.call(
        document.querySelectorAll('[data-follow]')
    );

    follows.forEach(function (follow) {

        follow.addEventListener('click', function (event) {

            event.preventDefault();

            let request = new XMLHttpRequest();

            if (follow.classList.contains(follow.dataset.toggle)) {
                request.open('POST', follow.dataset.unfollow, true);
                follow.innerText = follow.dataset.follow_label;
            } else {
                request.open('POST', follow.dataset.follow, true);
                follow.innerText = follow.dataset.following_label;
            }

            request.setRequestHeader('Content-Type', 'application/json');

            request.send(JSON.stringify({
                _token: CSRF_TOKEN
            }));

            follow.classList.toggle(follow.dataset.toggle);
        });
    });


    /**
     * Handle basic replies.
     */
    let replies = Array.prototype.slice.call(
        document.querySelectorAll('[data-reply]')
    );

    let textarea = document.querySelector('.forum__reply textarea');

    if (textarea) {
        replies.forEach(function (reply) {
            reply.addEventListener('click', function (event) {

                event.preventDefault();

                textarea.value = reply.dataset.reply + ' ';

                textarea.focus();
            });
        });
    }

})(window, document);
