<?php namespace Visiosoft\ForumModule\Mention;

class MentionParser
{

    /**
     * Parse the mentions from a content string.
     *
     * @param string $content
     * @return array
     */
    public function parse(string $content)
    {
        preg_match_all('/(@\w+)/', $content, $matches);

        return array_map(
            function ($match) {
                return str_slug(substr($match, 1), '_');
            },
            array_unique(array_flatten($matches))
        );
    }
}
