<?php namespace Visiosoft\ForumModule\Http\Controller\Admin;

use Visiosoft\ForumModule\Comment\Contract\CommentInterface;
use Visiosoft\ForumModule\Comment\Contract\CommentRepositoryInterface;
use Visiosoft\ForumModule\Comment\Form\CommentFormBuilder;
use Visiosoft\ForumModule\Comment\Table\CommentTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class CommentsController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param  CommentTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(CommentTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param  CommentFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(CommentFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param  CommentFormBuilder $form
     * @param                                             $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(CommentFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    /**
     * Redirect to a comment.
     *
     * @param  CommentRepositoryInterface $comments
     * @param                                    $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function view(CommentRepositoryInterface $comments, $id)
    {
        /* @var CommentInterface $comment */
        $comment = $comments->find($id);

        return $this->redirect->to($comment->route('view'));
    }
}
