<?php namespace Visiosoft\ForumModule\Discussion\Command;

use Visiosoft\ForumModule\Discussion\Contract\DiscussionInterface;
use Visiosoft\ForumModule\Participation\Contract\ParticipationInterface;
use Visiosoft\ForumModule\Participation\Contract\ParticipationRepositoryInterface;
use Anomaly\Streams\Platform\Model\EloquentModel;
use Anomaly\Streams\Platform\User\Contract\UserInterface;
use Illuminate\Contracts\Auth\Guard;

class FollowDiscussion
{

    /**
     * The discussion interface.
     *
     * @var DiscussionInterface
     */
    protected $discussion;

    /**
     * The user instance.
     *
     * @var UserInterface
     */
    protected $user;

    /**
     * Create a new LikeDiscussion instance.
     *
     * @param DiscussionInterface $discussion
     * @param UserInterface|null $user
     */
    public function __construct(DiscussionInterface $discussion, UserInterFace $user = null)
    {
        $this->user       = $user;
        $this->discussion = $discussion;
    }

    /**
     * Handle the command.
     *
     * @param ParticipationRepositoryInterface $participation
     * @param Guard $auth
     * @return bool
     * @throws \Exception
     */
    public function handle(ParticipationRepositoryInterface $participation, Guard $auth)
    {
        /* @var UserInterface $user */
        if (!$this->user = $this->user ?: $auth->user()) {
            throw new \Exception('You must be logged in to follow a discussion.');
        }

        /* @var ParticipationInterface|EloquentModel $participant */
        if (!$participant = $participation->findByDiscussionAndUser($this->discussion, $this->user)) {
            $participation->create(
                [
                    'discussion' => $this->discussion,
                    'user'       => $this->user,
                    'read_at'    => time(),
                    'following'  => true,
                ]
            );

            return true;
        }

        $participant->setAttribute('following', true);

        return $participation->save($participant);
    }
}
