<?php namespace Visiosoft\ForumModule\Comment\Contract;

use Visiosoft\ForumModule\Discussion\Contract\DiscussionInterface;
use Visiosoft\ForumModule\Flag\FlagCollection;
use Visiosoft\ForumModule\Mention\MentionCollection;
use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\User\Contract\UserInterface;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\MorphMany;

interface CommentInterface extends EntryInterface
{

    /**
     * Return mentioned usernames.
     *
     * @param UserInterface $user
     * @return array
     */
    public function mentions(UserInterface $user = null);

    /**
     * Return the flagged flag.
     *
     * @return bool
     */
    public function isFlagged();

    /**
     * Return the liked flag.
     *
     * @return bool
     */
    public function isLiked();

    /**
     * Get the created by username.
     *
     * @return string
     */
    public function getCreatedByUsername();

    /**
     * Get the created by ID.
     *
     * @return int
     */
    public function getCreatedById();

    /**
     * Get the content.
     *
     * @return string
     */
    public function getContent();

    /**
     * Get the related discussion.
     *
     * @return DiscussionInterface
     */
    public function getDiscussion();

    /**
     * Get the related discussion title.
     *
     * @return string
     */
    public function getDiscussionTitle();

    /**
     * Return the discussion relation.
     *
     * @return BelongsTo
     */
    public function discussion();

}
