<?php namespace Visiosoft\ForumModule\Http\Controller;

use Visiosoft\ForumModule\Channel\ChannelAuthorizer;
use Visiosoft\ForumModule\Channel\Contract\ChannelRepositoryInterface;
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Http\RedirectResponse;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class ChannelsController
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class ChannelsController extends PublicController
{

    /**
     * View an existing channel.
     *
     * @param ChannelRepositoryInterface $channels
     * @param ChannelAuthorizer $authorizer
     * @param $slug
     * @return Response
     */
    public function view(
        ChannelRepositoryInterface $channels,
        ChannelAuthorizer $authorizer,
        $slug
    ) {
        if (!$channel = $channels->findBySlug($slug)) {
            abort(404);
        }

        if (($response = $authorizer->authorize($channel)) instanceof RedirectResponse) {
            return $response;
        }

        $this->breadcrumbs->add(
            'visiosoft.module.forum::breadcrumb.forum',
            $this->url->route('visiosoft.module.forum::discussions.index')
        );

        $this->breadcrumbs->add(
            $channel->getName(),
            $channel->route('view')
        );

        $this->template->set('channel', $channel);
        $this->template->set('meta_title', $channel->getTitle());
        $this->template->set('meta_description', $channel->getDescription());

        return $this->view->make('visiosoft.module.forum::channels.view', compact('channel'));
    }
}
