<?php namespace Visiosoft\ForumModule\Http\Controller\Admin;

use Visiosoft\ForumModule\Discussion\Contract\DiscussionInterface;
use Visiosoft\ForumModule\Discussion\Contract\DiscussionRepositoryInterface;
use Visiosoft\ForumModule\Discussion\Form\DiscussionFormBuilder;
use Visiosoft\ForumModule\Discussion\Table\DiscussionTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class DiscussionsController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param  DiscussionTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(DiscussionTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param  DiscussionFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(DiscussionFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param  DiscussionFormBuilder $form
     * @param                                             $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(DiscussionFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    /**
     * Redirect to a discussion.
     *
     * @param  DiscussionRepositoryInterface $discussions
     * @param                                    $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function view(DiscussionRepositoryInterface $discussions, $id)
    {
        /* @var DiscussionInterface $discussion */
        $discussion = $discussions->find($id);

        return $this->redirect->to($discussion->route('view'));
    }
}
