<?php namespace Visiosoft\ForumModule;

use Visiosoft\ForumModule\Channel\ChannelModel;
use Visiosoft\ForumModule\Channel\ChannelRepository;
use Visiosoft\ForumModule\Channel\Contract\ChannelRepositoryInterface;
use Visiosoft\ForumModule\Comment\CommentModel;
use Visiosoft\ForumModule\Comment\CommentRepository;
use Visiosoft\ForumModule\Comment\Contract\CommentRepositoryInterface;
use Visiosoft\ForumModule\Comment\Form\CommentFormBuilder;
use Visiosoft\ForumModule\Discussion\Contract\DiscussionRepositoryInterface;
use Visiosoft\ForumModule\Discussion\DiscussionModel;
use Visiosoft\ForumModule\Discussion\DiscussionRepository;
use Visiosoft\ForumModule\Discussion\Form\DiscussionFormBuilder;
use Visiosoft\ForumModule\Http\Controller\Admin\AssignmentsController;
use Visiosoft\ForumModule\Http\Controller\Admin\FieldsController;
use Visiosoft\ForumModule\Participation\Contract\ParticipationRepositoryInterface;
use Visiosoft\ForumModule\Participation\ParticipationModel;
use Visiosoft\ForumModule\Participation\ParticipationRepository;
use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Assignment\AssignmentRouter;
use Anomaly\Streams\Platform\Field\FieldRouter;
use Anomaly\Streams\Platform\Model\Forum\ForumChannelsEntryModel;
use Anomaly\Streams\Platform\Model\Forum\ForumCommentsEntryModel;
use Anomaly\Streams\Platform\Model\Forum\ForumDiscussionsEntryModel;
use Anomaly\Streams\Platform\Model\Forum\ForumParticipationEntryModel;

/**
 * Class ForumModuleServiceProvider
 *
 * @link          http://pyrocms.com/
 * @author        PyroCMS, Inc. <support@pyrocms.com>
 * @author        Ryan Thompson <ryan@pyrocms.com>
 */
class ForumModuleServiceProvider extends AddonServiceProvider
{

    /**
     * The addon bindings.
     *
     * @var array
     */
    protected $bindings = [
        'forms::forum.comments'             => CommentFormBuilder::class,
        'forms::forum.discussions'          => DiscussionFormBuilder::class,
        ForumParticipationEntryModel::class => ParticipationModel::class,
        ForumDiscussionsEntryModel::class   => DiscussionModel::class,
        ForumChannelsEntryModel::class      => ChannelModel::class,
        ForumCommentsEntryModel::class      => CommentModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @var array
     */
    protected $singletons = [
        ParticipationRepositoryInterface::class => ParticipationRepository::class,
        DiscussionRepositoryInterface::class    => DiscussionRepository::class,
        ChannelRepositoryInterface::class       => ChannelRepository::class,
        CommentRepositoryInterface::class       => CommentRepository::class,
    ];

    /**
     * The addon routes.
     *
     * @var array
     */
    protected $routes = [
        'forum/rss.xml'                                       => [
            'as'   => 'anomaly.module.posts::posts.rss',
            'uses' => 'Visiosoft\ForumModule\Http\Controller\RssController@recent',
        ],
        'forum/rss/channels/{channel}.xml'                    => [
            'as'   => 'visiosoft.module.forum::channels.rss',
            'uses' => 'Visiosoft\ForumModule\Http\Controller\RssController@channel',
        ],
        'forum'                                               => [
            'as'   => 'visiosoft.module.forum::discussions.index',
            'uses' => 'Visiosoft\ForumModule\Http\Controller\DiscussionsController@index',
        ],
        'forum/discussions/create'                            => [
            'as'                               => 'visiosoft.module.forum::discussions.create',
            'anomaly.module.users::permission' => 'visiosoft.module.forum::discussions.write',
            'uses'                             => 'Visiosoft\ForumModule\Http\Controller\DiscussionsController@create',
        ],
        'forum/discussions/{id}/edit'                         => [
            'as'                               => 'visiosoft.module.forum::discussions.edit',
            'anomaly.module.users::permission' => 'visiosoft.module.forum::discussions.write',
            'uses'                             => 'Visiosoft\ForumModule\Http\Controller\DiscussionsController@edit',
        ],
        'forum/discussions/{id}/delete'                       => [
            'as'                               => 'visiosoft.module.forum::discussions.delete',
            'anomaly.module.users::permission' => 'visiosoft.module.forum::discussions.delete',
            'uses'                             => 'Visiosoft\ForumModule\Http\Controller\DiscussionsController@delete',
        ],
        'forum/discussions/{id}/lock'                         => [
            'as'                               => 'visiosoft.module.forum::discussions.lock',
            'anomaly.module.users::permission' => 'visiosoft.module.forum::discussions.lock',
            'uses'                             => 'Visiosoft\ForumModule\Http\Controller\DiscussionsController@lock',
        ],
        'forum/discussions/{id}/unlock'                       => [
            'as'                               => 'visiosoft.module.forum::discussions.unlock',
            'anomaly.module.users::permission' => 'visiosoft.module.forum::discussions.lock',
            'uses'                             => 'Visiosoft\ForumModule\Http\Controller\DiscussionsController@unlock',
        ],
        'forum/discussions/{id}/pin'                          => [
            'as'                               => 'visiosoft.module.forum::discussions.pin',
            'anomaly.module.users::permission' => 'visiosoft.module.forum::discussions.pin',
            'uses'                             => 'Visiosoft\ForumModule\Http\Controller\DiscussionsController@pin',
        ],
        'forum/discussions/{id}/unpin'                        => [
            'as'                               => 'visiosoft.module.forum::discussions.unpin',
            'anomaly.module.users::permission' => 'visiosoft.module.forum::discussions.pin',
            'uses'                             => 'Visiosoft\ForumModule\Http\Controller\DiscussionsController@unpin',
        ],
        'forum/discussions/{id}/follow'                       => [
            'as'   => 'visiosoft.module.forum::discussions.follow',
            'uses' => 'Visiosoft\ForumModule\Http\Controller\DiscussionsController@follow',
        ],
        'forum/discussions/{id}/unfollow'                     => [
            'as'   => 'visiosoft.module.forum::discussions.unfollow',
            'uses' => 'Visiosoft\ForumModule\Http\Controller\DiscussionsController@unfollow',
        ],
        'forum/discussions/{id}/flag'                         => [
            'as'                               => 'visiosoft.module.forum::discussions.flag',
            'anomaly.module.users::permission' => 'visiosoft.module.forum::flags.write',
            'uses'                             => 'Visiosoft\ForumModule\Http\Controller\DiscussionsController@flag',
        ],
        'forum/discussions/{id}/unflag'                       => [
            'as'                               => 'visiosoft.module.forum::discussions.unflag',
            'anomaly.module.users::permission' => 'visiosoft.module.forum::flags.delete',
            'uses'                             => 'Visiosoft\ForumModule\Http\Controller\DiscussionsController@unflag',
        ],
        'forum/discussions/{id}/like'                         => [
            'as'   => 'visiosoft.module.forum::discussions.like',
            'uses' => 'Visiosoft\ForumModule\Http\Controller\DiscussionsController@like',
        ],
        'forum/discussions/{id}/unlike'                       => [
            'as'   => 'visiosoft.module.forum::discussions.unlike',
            'uses' => 'Visiosoft\ForumModule\Http\Controller\DiscussionsController@unlike',
        ],
        'forum/comments/{id}/edit'                            => [
            'as'                               => 'visiosoft.module.forum::comments.edit',
            'anomaly.module.users::permission' => 'visiosoft.module.forum::comments.write',
            'uses'                             => 'Visiosoft\ForumModule\Http\Controller\CommentsController@edit',
        ],
        'forum/comments/{id}/flag'                            => [
            'as'                               => 'visiosoft.module.forum::comments.flag',
            'anomaly.module.users::permission' => 'visiosoft.module.forum::flags.write',
            'uses'                             => 'Visiosoft\ForumModule\Http\Controller\CommentsController@flag',
        ],
        'forum/comments/{id}/unflag'                          => [
            'as'                               => 'visiosoft.module.forum::comments.unflag',
            'anomaly.module.users::permission' => 'visiosoft.module.forum::flags.delete',
            'uses'                             => 'Visiosoft\ForumModule\Http\Controller\CommentsController@unflag',
        ],
        'forum/channels/{channel}/{slug}'                     => [
            'as'   => 'visiosoft.module.forum::discussions.view',
            'uses' => 'Visiosoft\ForumModule\Http\Controller\DiscussionsController@view',
        ],
        'forum/channels/{channel}/{discussion}#comment-{id}' => [
            'as'   => 'visiosoft.module.forum::comments.view',
            'uses' => 'Visiosoft\ForumModule\Http\Controller\DiscussionsController@view',
        ],
        'forum/channels/{slug}'                               => [
            'as'   => 'visiosoft.module.forum::channels.view',
            'uses' => 'Visiosoft\ForumModule\Http\Controller\ChannelsController@view',
        ],
        'forum/comments/{id}/delete'                          => [
            'as'                               => 'visiosoft.module.forum::comments.delete',
            'anomaly.module.users::permission' => 'visiosoft.module.forum::comments.delete',
            'uses'                             => 'Visiosoft\ForumModule\Http\Controller\CommentsController@delete',
        ],
        'forum/flags/{id}/delete'                             => [
            'as'                               => 'visiosoft.module.forum::flags.delete',
            'anomaly.module.users::permission' => 'visiosoft.module.forum::flags.delete',
            'uses'                             => 'Visiosoft\ForumModule\Http\Controller\FlagsController@unflag',
        ],
        'forum/comments/{id}/answer'                          => [
            'as'   => 'visiosoft.module.forum::comments.answer',
            'uses' => 'Visiosoft\ForumModule\Http\Controller\CommentsController@answer',
        ],
        'forum/comments/{id}/like'                            => [
            'as'   => 'visiosoft.module.forum::comments.like',
            'uses' => 'Visiosoft\ForumModule\Http\Controller\CommentsController@like',
        ],
        'forum/comments/{id}/unlike'                          => [
            'as'   => 'visiosoft.module.forum::comments.unlike',
            'uses' => 'Visiosoft\ForumModule\Http\Controller\CommentsController@unlike',
        ],

        'admin/forum'                    => 'Visiosoft\ForumModule\Http\Controller\Admin\DiscussionsController@index',
        'admin/forum/create'             => 'Visiosoft\ForumModule\Http\Controller\Admin\DiscussionsController@create',
        'admin/forum/edit/{id}'          => 'Visiosoft\ForumModule\Http\Controller\Admin\DiscussionsController@edit',
        'admin/forum/view/{id}'          => 'Visiosoft\ForumModule\Http\Controller\Admin\DiscussionsController@view',
        'admin/forum/comments'           => 'Visiosoft\ForumModule\Http\Controller\Admin\CommentsController@index',
        'admin/forum/comments/create'    => 'Visiosoft\ForumModule\Http\Controller\Admin\CommentsController@create',
        'admin/forum/comments/edit/{id}' => 'Visiosoft\ForumModule\Http\Controller\Admin\CommentsController@edit',
        'admin/forum/comments/view/{id}' => 'Visiosoft\ForumModule\Http\Controller\Admin\CommentsController@view',
        'admin/forum/channels'           => 'Visiosoft\ForumModule\Http\Controller\Admin\ChannelsController@index',
        'admin/forum/channels/create'    => 'Visiosoft\ForumModule\Http\Controller\Admin\ChannelsController@create',
        'admin/forum/channels/edit/{id}' => 'Visiosoft\ForumModule\Http\Controller\Admin\ChannelsController@edit',
        'admin/forum/channels/view/{id}' => 'Visiosoft\ForumModule\Http\Controller\Admin\ChannelsController@view',
    ];

    /**
     * Map the addon.
     *
     * @param  FieldRouter $fields
     * @param  AssignmentRouter $assignments
     */
    public function map(FieldRouter $fields, AssignmentRouter $assignments)
    {
        $fields->route($this->addon, FieldsController::class);

        $assignments->route(
            $this->addon,
            AssignmentsController::class,
            'admin/forum'
        );
    }

}
