<?php namespace Visiosoft\ForumModule;

use Anomaly\Streams\Platform\Addon\Module\Module;

/**
 * Class ForumModule
 *
 * @link          http://pyrocms.com/
 * @author        PyroCMS, Inc. <support@pyrocms.com>
 * @author        Ryan Thompson <ryan@pyrocms.com>
 */
class ForumModule extends Module
{

    /**
     * The addon icon.
     *
     * @var string
     */
    protected $icon = 'fa fa-comments-o';

    /**
     * The module sections.
     *
     * @var array
     */
    protected $sections = [
        'discussions',
        'comments',
        'channels'    => [
            'buttons' => [
                'new_channel',
            ],
        ],
        'assignments' => [
            'href'    => 'admin/forum/assignments/channels',
            'buttons' => [
                'assign_fields' => [
                    'data-toggle' => 'modal',
                    'data-target' => '#modal',
                    'href'        => 'admin/forum/assignments/channels/choose',
                ],
            ],
        ],
        'fields'      => [
            'buttons' => [
                'new_field' => [
                    'data-toggle' => 'modal',
                    'data-target' => '#modal',
                    'href'        => 'admin/forum/fields/choose',
                ],
            ],
        ],
    ];

}
