<?php namespace Visiosoft\ForumModule\Discussion;

use Visiosoft\ForumModule\Discussion\Contract\DiscussionRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;

class DiscussionSeeder extends Seeder
{

    /**
     * The discussion repository.
     *
     * @var DiscussionRepositoryInterface
     */
    protected $discussions;

    /**
     * Create a new DiscussionSeeder instance.
     *
     * @param DiscussionRepositoryInterface $discussions
     */
    public function __construct(DiscussionRepositoryInterface $discussions)
    {
        $this->discussions = $discussions;

        parent::__construct();
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        $this->discussions->create(
            [
                'created_by_id' => 1,
                'channel'       => 1,
                'title'         => 'This is an example discussion.',
                'content'       => 'Discussion content supports **markdown** content.',
                'ip_address'    => '::1',
            ]
        );
    }
}
