<?php namespace Visiosoft\ForumModule\Discussion;

use Visiosoft\ForumModule\Discussion\Command\FlagDiscussion;
use Visiosoft\ForumModule\Discussion\Command\FollowDiscussion;
use Visiosoft\ForumModule\Discussion\Command\LikeDiscussion;
use Visiosoft\ForumModule\Discussion\Command\UnflagDiscussion;
use Visiosoft\ForumModule\Discussion\Command\UnfollowDiscussion;
use Visiosoft\ForumModule\Discussion\Command\UnlikeDiscussion;
use Visiosoft\ForumModule\Discussion\Contract\DiscussionInterface;
use Anomaly\Streams\Platform\User\Contract\UserInterface;

class DiscussionManager
{

    /**
     * Flag a discussion.
     *
     * @param DiscussionInterface $discussion
     * @return bool
     */
    public function flag(DiscussionInterface $discussion)
    {
        return dispatch_now(new FlagDiscussion($discussion));
    }

    /**
     * Unflag a discussion.
     *
     * @param DiscussionInterface $discussion
     * @return bool
     */
    public function unflag(DiscussionInterface $discussion)
    {
        return dispatch_now(new UnflagDiscussion($discussion));
    }

    /**
     * Follow a discussion.
     *
     * @param DiscussionInterface $discussion
     * @param UserInterface|null $user
     * @return bool
     */
    public function follow(DiscussionInterface $discussion, UserInterface $user = null)
    {
        return dispatch_now(new FollowDiscussion($discussion, $user));
    }

    /**
     * Unfollow a discussion.
     *
     * @param DiscussionInterface $discussion
     * @param UserInterface|null $user
     * @return bool
     */
    public function unfollow(DiscussionInterface $discussion, UserInterface $user = null)
    {
        return dispatch_now(new UnfollowDiscussion($discussion, $user));
    }

    /**
     * Like a discussion.
     *
     * @param DiscussionInterface $discussion
     * @param UserInterface|null $user
     * @return bool
     */
    public function like(DiscussionInterface $discussion, UserInterface $user = null)
    {
        return dispatch_now(new LikeDiscussion($discussion, $user));
    }

    /**
     * Unlike a discussion.
     *
     * @param DiscussionInterface $discussion
     * @param UserInterface|null $user
     * @return bool
     */
    public function unlike(DiscussionInterface $discussion, UserInterface $user = null)
    {
        return dispatch_now(new UnlikeDiscussion($discussion, $user));
    }
}
