<?php namespace Visiosoft\ForumModule\Comment\Notification;

use Visiosoft\ForumModule\Comment\Contract\CommentInterface;
use Anomaly\Streams\Platform\Notification\Message\MailMessage;
use Anomaly\Streams\Platform\User\Contract\UserInterface;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;

class CommentWasPosted extends Notification implements ShouldQueue
{

    use Queueable;

    /**
     * The comment instance.
     *
     * @var CommentInterface
     */
    public $comment;

    /**
     * Create a new CommentWasPosted instance.
     *
     * @param CommentInterface $comment
     */
    public function __construct(CommentInterface $comment)
    {
        $this->comment = $comment;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  UserInterface $notifiable
     * @return array
     */
    public function via(UserInterface $notifiable)
    {
        return ['mail'];
    }

    /**
     * Return the mail message.
     *
     * @param  UserInterface $notifiable
     * @return MailMessage
     */
    public function toMail(UserInterface $notifiable)
    {
        $data = [
            'discussion' => $this->comment->getDiscussionTitle(),
            'username'   => $this->comment->getCreatedByUsername(),
        ];

        return (new MailMessage())
            ->view('visiosoft.module.forum::notifications.comment_was_posted')
            ->subject(trans('visiosoft.module.forum::notification.comment_was_posted.subject', $data))
            ->line(trans('visiosoft.module.forum::notification.comment_was_posted.message', $data))
            ->action(
                trans('visiosoft.module.forum::notification.comment_was_posted.button'),
                url($this->comment->route('view'))
            );
    }
}
