<?php namespace Visiosoft\ForumModule\Comment\Form;

use Visiosoft\ForumModule\Discussion\DiscussionModel;
use Anomaly\Streams\Platform\Model\EloquentModel;
use Anomaly\Streams\Platform\Support\Presenter;
use Anomaly\Streams\Platform\Ui\Form\FormCriteria;

class CommentFormCriteria extends FormCriteria
{

    /**
     * The comment form builder.
     *
     * @var CommentFormBuilder
     */
    protected $builder;

    /**
     * Build the builder.
     *
     * @return CommentFormBuilder
     */
    public function build()
    {
        if (isset($this->parameters['id'])) {
            $this->builder->setDiscussion(DiscussionModel::find($this->parameters['id']));
        }

        parent::build();

        return $this->builder;
    }

    /**
     * Set the entry.
     *
     * @param $discussion
     * @return $this
     * @throws \Exception
     */
    public function setDiscussion($discussion)
    {
        if ($discussion instanceof Presenter) {
            $discussion = $discussion->getObject();
        }

        if (!$discussion instanceof EloquentModel) {
            throw new \Exception('$discussion must be instance of ' . EloquentModel::class);
        }

        $this->parameters['id'] = $discussion->getId();

        return $this;
    }
}
