<?php namespace Visiosoft\ForumModule\Comment\Command;

use Visiosoft\ForumModule\Comment\Contract\CommentInterface;
use Illuminate\Http\Request;

class SetIpAddress
{

    /**
     * The comment instance.
     *
     * @var CommentInterface
     */
    protected $comment;

    /**
     * Create a new SetIpAddress instance.
     *
     * @param CommentInterface $comment
     */
    public function __construct(CommentInterface $comment)
    {
        $this->comment = $comment;
    }

    /**
     * Handle the command.
     *
     * @param Request $request
     */
    public function handle(Request $request)
    {
        $this->comment->setAttribute('ip_address', $request->getClientIp());
    }
}
