<?php namespace Visiosoft\ForumModule\Comment\Command;

use Visiosoft\ForumModule\Comment\Contract\CommentInterface;
use Visiosoft\ForumModule\Mention\MentionManager;
use Visiosoft\ForumModule\Mention\MentionParser;
use Anomaly\Streams\Platform\User\Contract\UserInterface;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Notifications\Notifiable;

class NotifyMentions
{

    /**
     * The comment instance.
     *
     * @var CommentInterface
     */
    protected $comment;

    /**
     * Create a new SetApproval instance.
     *
     * @param CommentInterface $comment
     */
    public function __construct(CommentInterface $comment)
    {
        $this->comment = $comment;
    }

    /**
     * Handle the command.
     *
     * @param MentionParser $parser
     * @param MentionManager $manager
     * @param UserRepositoryInterface $users
     */
    public function handle(
        MentionParser $parser,
        MentionManager $manager,
        UserRepositoryInterface $users
    ) {
        foreach ($parser->parse($this->comment->getContent()) as $mention) {

            /* @var Notifiable|UserInterface $user */
            if (!$user = $users->findByUsername($mention)) {
                continue;
            }

            $manager->send($user, $this->comment->getDiscussion(), $this->comment);
        }
    }
}
