<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Forum Blacklist
    |--------------------------------------------------------------------------
    |
    | Define blacklisted terms to be applied
    | to discussions and comments alike.
    */

    'blacklist' => array_filter(explode(',', env('FORUM_BLACKLIST'))),

    /*
    |--------------------------------------------------------------------------
    | Filters
    |--------------------------------------------------------------------------
    |
    | Specify available filters for the forum.
    */

    'filters' => [
        'mine'          => [
            'user'  => true,
            'title' => 'visiosoft.module.forum::filter.mine',
            'query' => \Visiosoft\ForumModule\Discussion\Filter\FilterMine::class,
        ],
        'participating' => [
            'user'  => true,
            'title' => 'visiosoft.module.forum::filter.participating',
            'query' => \Visiosoft\ForumModule\Discussion\Filter\FilterParticipating::class,
        ],
        'following'     => [
            'title' => 'visiosoft.module.forum::filter.following',
            'query' => \Visiosoft\ForumModule\Discussion\Filter\FilterFollowing::class,
        ],
        'trending'      => [
            'title' => 'visiosoft.module.forum::filter.trending',
            'query' => \Visiosoft\ForumModule\Discussion\Filter\FilterTrending::class,
        ],
        'popular'       => [
            'title' => 'visiosoft.module.forum::filter.popular',
            'query' => \Visiosoft\ForumModule\Discussion\Filter\FilterPopular::class,
        ],
        'answered'      => [
            'title' => 'visiosoft.module.forum::filter.answered',
            'query' => \Visiosoft\ForumModule\Discussion\Filter\FilterAnswered::class,
        ],
        'unanswered'    => [
            'title' => 'visiosoft.module.forum::filter.unanswered',
            'query' => \Visiosoft\ForumModule\Discussion\Filter\FilterUnanswered::class,
        ],
        'no_replies'    => [
            'title' => 'visiosoft.module.forum::filter.no_replies',
            'query' => \Visiosoft\ForumModule\Discussion\Filter\FilterNoReplies::class,
        ],
        'flagged'       => [
            'title'      => 'visiosoft.module.forum::filter.flagged',
            'permission' => 'visiosoft.module.forum::*.flag',
            'query'      => \Visiosoft\ForumModule\Discussion\Filter\FilterFlagged::class,
        ],
    ],

];
