<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleForumCreateForumFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'title'         => 'anomaly.field_type.text',
        'name'          => 'anomaly.field_type.text',
        'slug'          => [
            'type'   => 'anomaly.field_type.slug',
            'config' => [
                'type' => '-',
            ],
        ],
        'content'       => 'anomaly.field_type.textarea',
        'description'   => 'anomaly.field_type.textarea',
        'ip_address'    => 'anomaly.field_type.text',
        'following'     => 'anomaly.field_type.boolean',
        'flagged'       => 'anomaly.field_type.boolean',
        'locked'        => 'anomaly.field_type.boolean',
        'pinned'        => 'anomaly.field_type.boolean',
        'liked'         => 'anomaly.field_type.boolean',
        'view_count'    => 'anomaly.field_type.integer',
        'comment_count' => 'anomaly.field_type.integer',
        'approved'     => 'anomaly.field_type.boolean',
        'user'          => [
            'type'   => 'anomaly.field_type.relationship',
            'config' => [
                'related' => 'Anomaly\UsersModule\User\UserModel',
            ],
        ],
        'channel'       => [
            'type'   => 'anomaly.field_type.relationship',
            'config' => [
                'related' => 'Visiosoft\ForumModule\Channel\ChannelModel',
            ],
        ],
        'comment'       => [
            'type'   => 'anomaly.field_type.relationship',
            'config' => [
                'related' => 'Visiosoft\ForumModule\Comment\CommentModel',
            ],
        ],
        'answer'        => [
            'type'   => 'anomaly.field_type.relationship',
            'config' => [
                'related' => 'Visiosoft\ForumModule\Comment\CommentModel',
            ],
        ],
        'discussion'    => [
            'type'   => 'anomaly.field_type.relationship',
            'config' => [
                'related' => 'Visiosoft\ForumModule\Discussion\DiscussionModel',
            ],
        ],
        'read_at'       => [
            'type'   => 'anomaly.field_type.datetime',
            'config' => [
                'mode' => 'datetime',
            ],
        ],
        'flagged_by'    => [
            'type'   => 'anomaly.field_type.relationship',
            'config' => [
                'related' => 'Anomaly\UsersModule\User\UserModel',
            ],
        ],
        'locked_by'     => [
            'type'   => 'anomaly.field_type.relationship',
            'config' => [
                'related' => 'Anomaly\UsersModule\User\UserModel',
            ],
        ],
        'pinned_by'     => [
            'type'   => 'anomaly.field_type.relationship',
            'config' => [
                'related' => 'Anomaly\UsersModule\User\UserModel',
            ],
        ],
        'allowed_roles' => [
            'type'   => 'anomaly.field_type.multiple',
            'config' => [
                'related' => 'Anomaly\UsersModule\Role\RoleModel',
            ],
        ],
    ];
}
