<?php namespace Visiosoft\ForumModule\Discussion\Form;

use Illuminate\Routing\Redirector;

class DiscussionFormHandler
{

    /**
     * Handle the form.
     *
     * @param DiscussionFormBuilder $builder
     * @param Redirector $redirect
     */
    public function handle(DiscussionFormBuilder $builder, Redirector $redirect)
    {
        if (!$builder->canSave()) {
            return;
        }

        $builder->saveForm();

        $discussion = $builder->getFormEntry();

        $builder->setFormResponse($redirect->to($discussion->route('view')));
    }
}
