<?php namespace Visiosoft\ForumModule\Discussion\Contract;

use Visiosoft\ForumModule\Channel\Contract\ChannelInterface;
use Visiosoft\ForumModule\Discussion\DiscussionCollection;
use Anomaly\Streams\Platform\Entry\Contract\EntryRepositoryInterface;

interface DiscussionRepositoryInterface extends EntryRepositoryInterface
{

    /**
     * Get recent discussions.
     *
     * @return DiscussionCollection
     */
    public function getRecent($limit = null);

    /**
     * Find a discussion by slug.
     *
     * @param $slug
     * @return DiscussionInterface
     */
    public function findBySlug($slug);

    /**
     * Find many discussions by channel.
     *
     * @param ChannelInterface $channel
     * @param $limit
     * @return DiscussionCollection
     */
    public function findManyByChannel(ChannelInterface $channel, $limit);
}
