<?php namespace Visiosoft\ForumModule\Discussion\Command;

use Visiosoft\ForumModule\Discussion\Contract\DiscussionInterface;
use Visiosoft\ForumModule\Discussion\Contract\DiscussionRepositoryInterface;
use Anomaly\Streams\Platform\Model\EloquentModel;

class SetUniqueSlug
{

    /**
     * The discussion instance.
     *
     * @var DiscussionInterface|EloquentModel
     */
    protected $discussion;

    /**
     * Create a new SetUniqueSlug instance.
     *
     * @param DiscussionInterface $discussion
     */
    public function __construct(DiscussionInterface $discussion)
    {
        $this->discussion = $discussion;
    }

    /**
     * Handle the command.
     *
     * @param DiscussionRepositoryInterface $discussions
     */
    public function handle(DiscussionRepositoryInterface $discussions)
    {

        /**
         * First set the slug if
         * there is not one yet.
         */
        if (!$this->discussion->getAttribute('slug')) {
            $this->discussion->setAttribute('slug', str_slug($this->discussion->getTitle()));
        }

        /**
         * If we have another discussion named the
         * same then try setting the slug again.
         */
        if ($discussion = $discussions->findBySlug($this->discussion->getSlug())) {

            $count = 1;

            while ($discussions->findBySlug($this->discussion->getSlug() . '-' . $count)) {
                $count += 1;
            }

            $this->discussion->setAttribute('slug', $this->discussion->getSlug() . '-' . $count);
        }
    }
}
