<?php namespace Visiosoft\ForumModule\Comment\Command;

use Visiosoft\ForumModule\Comment\Contract\CommentInterface;
use Visiosoft\ForumModule\Discussion\Contract\DiscussionInterface;
use Visiosoft\ForumModule\Discussion\Contract\DiscussionRepositoryInterface;
use Anomaly\Streams\Platform\Model\EloquentModel;

class DecrementCommentCount
{

    /**
     * The comment instance.
     *
     * @var CommentInterface
     */
    protected $comment;

    /**
     * Create a new SetApproval instance.
     *
     * @param CommentInterface $comment
     */
    public function __construct(CommentInterface $comment)
    {
        $this->comment = $comment;
    }

    /**
     * Handle the command.
     *
     * @param DiscussionRepositoryInterface $discussions
     */
    public function handle(DiscussionRepositoryInterface $discussions)
    {
        if (!$this->comment->isForceDeleting()) {
            return;
        }

        /* @var DiscussionInterface|EloquentModel $discussion */
        $discussion = $this->comment->getDiscussion();

        $discussions->save($discussion->setAttribute('comment_count', $discussion->getCommentCount() - 1));
    }
}
