<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleForumCreateDiscussionsStream extends Migration
{

    /**
     * Delete this stream when resetting.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug'         => 'discussions',
        'title_column' => 'title',
        'searchable'   => true,
        'trashable'    => true,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'channel'    => [
            'required' => true,
        ],
        'title'      => [
            'required' => true,
        ],
        'slug'       => [
            'required' => true,
            'unique'   => true,
            'config'   => [
                'slugify' => 'title',
            ],
        ],
        'content'    => [
            'required' => true,
        ],
        'ip_address' => [
            'required' => true,
        ],
        'view_count',
        'comment_count',
        'answer',
        'locked',
        'locked_by',
        'pinned',
        'pinned_by',
        'flagged',
        'flagged_by',
        'approved',
        'approved_by',
    ];
}
