<?php namespace Visiosoft\ForetagandeTheme;

use Anomaly\PagesModule\Page\Contract\PageRepositoryInterface;
use Anomaly\PagesModule\Type\Contract\TypeInterface;
use Anomaly\PagesModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterFaqRepeaterEntryModel;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterFeaturesRepeaterEntryModel;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;

class ForetagandeThemeSeeder extends Seeder
{
    protected $fields;
    protected $streamRepository;
    protected $assignments;
    protected $types;
    protected $pages;

    public function __construct(
        PageRepositoryInterface       $pages,
        FieldRepositoryInterface      $fields,
        StreamRepositoryInterface     $streamRepository,
        AssignmentRepositoryInterface $assignments,
        TypeRepositoryInterface       $types
    )
    {
        $this->pages = $pages;
        $this->fields = $fields;
        $this->streamRepository = $streamRepository;
        $this->assignments = $assignments;
        $this->types = $types;
    }

    public function run()
    {

        $type = $this->types->findBySlug('default');

        $stream = $type->getEntryStream();
        $type->update([
            'layout'       => '{{ page.editor.render|raw }}',
        ]);
        $type->save();

        if (!$this->fields->findBySlugAndNamespace('editor', 'pages')) {
            $this->fields->create([
                'name' => 'Editor',
                'namespace' => 'pages',
                'slug' => 'editor',
                'type' => 'anomaly.field_type.editor',
                'locked' => 0,
                'config' => [
                    'translatable' => true,
                ]
            ]);

            $this->assignments->create(
                [
                    'translatable' => true,
                    'stream'       => $stream,
                    'field'        => $this->fields->findBySlugAndNamespace('editor', 'pages'),
                ]
            );
        }


        $pages = [
            'faq-page' => [
                'en' => [
                    'title' => 'Faq Page',
                ],
                'slug'         => 'faq-page',
                'entry' => $type->getEntryModel()->create(
                    [
                        'en' => [
                            'editor' => '
                            <section class="faq">
                                        <div class="container">
                                            <h2 class="faq-title">Frequently Asked Questions</h2>
                                            <div class="row">
                                                <div class="col-12">

                                                    <div class="accordion" id="faq">

                                                        <div class="faq-section">
                                                            <div class="faq-header" id="faqhead1">
                                                                <div  class="faq-question collapsed" data-toggle="collapse" data-target="#faq1"
                                                                      aria-expanded="true" aria-controls="faq1">
                                                                    Question
                                                                </div>
                                                            </div>

                                                            <div id="faq1" class="collapse x" aria-labelledby="faqhead1" data-parent="#faq">
                                                                <div class="faq-body">
                                                                    Answer
                                                                </div>
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="faq-section">
                                                            <div class="faq-header" id="faqhead2">
                                                                <div  class="faq-question collapsed" data-toggle="collapse" data-target="#faq2"
                                                                      aria-expanded="true" aria-controls="faq2">
                                                                    Question
                                                                </div>
                                                            </div>

                                                            <div id="faq2" class="collapse x" aria-labelledby="faqhead2" data-parent="#faq">
                                                                <div class="faq-body">
                                                                    Answer
                                                                </div>
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="faq-section">
                                                            <div class="faq-header" id="faqhead3">
                                                                <div  class="faq-question collapsed" data-toggle="collapse" data-target="#faq3"
                                                                      aria-expanded="true" aria-controls="faq3">
                                                                    Question
                                                                </div>
                                                            </div>

                                                            <div id="faq3" class="collapse x" aria-labelledby="faqhead3" data-parent="#faq">
                                                                <div class="faq-body">
                                                                    Answer
                                                                </div>
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="faq-section">
                                                            <div class="faq-header" id="faqhead4">
                                                                <div  class="faq-question collapsed" data-toggle="collapse" data-target="#faq4"
                                                                      aria-expanded="true" aria-controls="faq4">
                                                                    Question
                                                                </div>
                                                            </div>

                                                            <div id="faq4" class="collapse x" aria-labelledby="faqhead4" data-parent="#faq">
                                                                <div class="faq-body">
                                                                    Answer
                                                                </div>
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="faq-section">
                                                            <div class="faq-header" id="faqhead5">
                                                                <div  class="faq-question collapsed" data-toggle="collapse" data-target="#faq5"
                                                                      aria-expanded="true" aria-controls="faq5">
                                                                    Question
                                                                </div>
                                                            </div>

                                                            <div id="faq5" class="collapse x" aria-labelledby="faqhead5" data-parent="#faq">
                                                                <div class="faq-body">
                                                                    Answer
                                                                </div>
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                    </section>
                            ',
                        ],
                    ]
                ),
                'type'         => $type,
                'enabled'      => true,
                'home'         => false,
                'theme_layout' => 'theme::layouts/default.twig',
            ],
            'about-us' => [
                'en' => [
                    'title' => 'About Us',
                ],
                'slug'         => 'about-us',
                'entry' => $type->getEntryModel()->create(
                    [
                        'en' => [
                            'editor' => '
                                    <div class="about-us">
                                        <div class="container">
                                            <section class="about_us">
                                                    <div class="row">
                                                        <div class="col-12 col-lg-5">
                                                            <h2 class="about-head mt-4"> About Foretagande</h2>
                                                            <div>
                                                                <p class="about-desc mb-4">
																	Everything about us
                                                                </p>
                                                            </div>
                                                        </div>
                                                        <div class="col-12 col-lg-7">
                                                            <div class="about-images mt-3 mt-lg-0">
                                                                <div class="position-relative d-flex justify-content-center">
                                                                    {{ img(\'visiosoft.theme.foretagande::images/about/about-1.png\').class(\'about_image_1\')|raw }}
                                                                    {{ img(\'visiosoft.theme.foretagande::images/about/about-2.png\').class(\'about_image_2\')|raw }}
                                                                </div>
                                                                <div class="position-relative d-flex justify-content-center align-items-center">
                                                                    {{ img(\'visiosoft.theme.foretagande::images/about/about-3.png\').class(\'about_image_3\')|raw }}
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                            </section>
                                            <section class="about_services">
                                                <div class="services_head">
                                                    <h2 class="services_title">
                                                        Why Choose Us
                                                    </h2>
                                                    <p class="services_desc">
                                                        We provide full service at every step.
                                                    </p>
                                                </div>
                                                <div class="services_content">
                                                    <div class="row">
                                                        <div class="col-md-4 mb-5 mb-lg-0">
                                                        {{ img(\'visiosoft.theme.foretagande::images/about/card-1.png\')|raw }}
                                                            <div class="services_desc">
                                                                Lorem ipsum dolor sit amet, consectetur adipiscing elit.
                                                                 Duis mollis et sem sed sollicitudin. Donec non odio neque. 
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4 mb-5 mb-lg-0">
                                                        {{ img(\'visiosoft.theme.foretagande::images/about/card-2.png\')|raw }}
                                                            <div class="services_desc">
                                                                Lorem ipsum dolor sit amet, consectetur adipiscing elit.
                                                                 Duis mollis et sem sed sollicitudin. Donec non odio neque. 
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4 mb-5 mb-lg-0">
                                                        {{ img(\'visiosoft.theme.foretagande::images/about/card-3.png\')|raw }}
                                                            <div class="services_desc">
                                                                Lorem ipsum dolor sit amet, consectetur adipiscing elit.
                                                                 Duis mollis et sem sed sollicitudin. Donec non odio neque. 
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </section>
                                        </div>
                                    </div>
                            ',
                        ],
                    ]
                ),
                'type'         => $type,
                'enabled'      => true,
                'home'         => false,
                'theme_layout' => 'theme::layouts/default.twig',
            ],
        ];


        foreach ($pages as $key => $page) {
            if (!$this->pages->findByPath('/'.$page['slug'])) {
                $this->pages->create($page)->allowedRoles()->sync([]);
            }
        }

        if ($this->pages->findByPath('/contact')) {
            $contact_page = $this->pages->findByPath('/contact');
            $contact_page->update(
                [
                    'en' => [
                        'title' => 'Contact',
                    ],
                    'entry' => $type->getEntryModel()->create(
                        [
                            'en' => [
                                'editor' => '
                                    <section class="contact-us">
                                        <div class="container">
                                            <div class="row">
                                                <div class="col-12">
                                                    <h1 class="page-title">Contact Us</h1>
                                                </div>
                                                <div class="col-12 col-lg-4">
                                                    <div class="contact-left-section">
                                                        <div class="mb-3">
                                                            <h4 class="contact-info-title">Foretagande</h4>
                                                            <div class="contact-info-desc">
                                                                Contact to us.
                                                            </div>
                                                        </div>
                                                        <div class="contact-info-section">
                                                            <h6 class="contact-info-title">
                                                                address is here
                                                            </h6>
                                                            <div class="contact-info-desc d-flex">
                                                                <div>
                                                                    {{ img(\'visiosoft.theme.foretagande::images/icons/contact-location.svg\').class(\'mr-2\')|raw }}
                                                                </div>
                                                                address is here again
                                                            </div>
                                                        </div>
                                                        <div class="contact-info-section">
                                                            <h6 class="contact-info-title">
                                                                0232 323 23 23
                                                            </h6>
                                                            <div class="contact-info-desc">
                                                                {{ img(\'visiosoft.theme.foretagande::images/icons/contact-phone.svg\').class(\'mr-2\')|raw }}
                                                                0232 322 23 23s
                                                            </div>
                                                        </div>
                                                        <div class="contact-info-section">
                                                            <h6 class="contact-info-title">
                                                                Contact Us
                                                            </h6>
                                                            <div class="contact-info-desc">
                                                                {{ img(\'visiosoft.theme.foretagande::images/icons/contact-message.svg\').class(\'mr-2\')|raw }}
                                                                info@foretagande.se
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-12 col-lg-8 mt-4 mt-lg-0">
                                                    <div id="contact" class="contact-form-wrapper">
                                                        <h5 class="contact-info-title">Send us your message</h5>
                                                        <p class="contact-info-desc">
                                                            Contact us from this form to get support.
                                                        </p>

                                                        {% set form = form(\'contact\')
                                                            .from(setting_value(\'streams::email\'))
                                                            .to(setting_value(\'streams::email\'))
                                                            .handler(\'\\Visiosoft\\ContactPlugin\\Form\\ContactFormHandler@handle\')
                                                            .fields({
                                                                \'name\': { \'type\': \'anomaly.field_type.text\', \'required\': true, placeholder: trans(\'visiosoft.theme.restate::field.name_surname\'), \'class\': \'contact-input mb-3 \'},
                                                                \'email\': {\'type\': \'anomaly.field_type.text\', \'required\': true, placeholder: trans(\'visiosoft.theme.restate::field.email_address\'), \'class\': \'contact-input mb-3\'},
                                                                \'messages\': {\'type\': \'anomaly.field_type.textarea\', \'required\': true, placeholder: trans(\'visiosoft.theme.restate::field.messages\'),\'class\': \'contact-input \'},

                                                            }).
                                                            get() %}

                                                        {{ form.open|raw }}

                                                        {{ form.fields.name.input|raw }}
                                                        {{ form.fields.email.input|raw }}
                                                        {{ form.fields.messages.input|raw }}

                                                        <button class="contact-submit">Send Message</button>
                                                        {{ form.close|raw }}
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </section>
                                    ',
                            ],
                        ]
                    ),
                    'theme_layout' => 'theme::layouts/default.twig',
                ]
            );
            $contact_page->save();
        }

    }
}
