let closeModal = $('.custom-modal, .filter-location-back')
const advancedFilter = $('.advanced-filter');
const icon = $('.advanced_icon');
const advancedFilterBtn = $('.advanced-filter-btn');


$("#cats_btn").click(function () {
    $(closeModal).show();
    SelectWithClick();
});

$('.custom-modal-close, .filter-location-back').on('click', function () {
    $(closeModal).hide();
});

function searchCat() {
    var searchField = $("#searchCategory");
    searchField.off().on("keyup", function () {
        const value = this.value.toLocaleLowerCase(currentLocale).trim();
        $('.category-item').show().filter(function () {
            return $(this).text().toLocaleLowerCase(currentLocale).trim().indexOf(value) === -1;
        }).hide();
    });
}

function SelectWithClick() {
    var modalInput = $(".custom-modal-body input[type='checkbox']");
    var categoryInput = $('input[name="cats[]"]');
    var text_html = $('.selected-cats');

    modalInput.off();
    searchCat();

    return modalInput.on('change', function () {

        var input_text = $(this).parent().find('small').html();
        var text = "";
        let input_val = categoryInput.val() || "";

        var id = $(this).attr('data-id');

        if (input_val !== "") {
            input_val = input_val.split(',');
            text = text_html.html().split(',');
        } else {
            input_val = [];
            text = [];
        }
        if (this.checked) {
            input_val.push(id);
            text.push(input_text)
        } else {
            input_val.splice($.inArray(id, input_val), 1);
            text.splice($.inArray(input_text, text), 1);
        }
        categoryInput.val(input_val.join(','));
        text_html.html(text.join(', '))
    });
}


advancedFilterBtn.on('click', function () {
    const x = window.matchMedia("(max-width: 768px)");

    if (x.matches) {
        advancedFilter.toggleClass('d-none');
    }
    advancedFilter.toggleClass('active');
    icon.toggleClass('rotate-90deg');

});

$("#listFilterForm, #listFilterFormMobile, #breadcrumbListFilterForm").submit(function (e) {
    const inputs = $('#' + $(this).attr('id') + ' :input');

    [...inputs].forEach((input) => {
        if (input.type === 'checkbox' || input.type === 'radio') {
            if ($(input).prop("checked") == false) {
                $(input).prop('disabled', true);
            }
        } else {
            if ($(input).val() == "" || $(input).find(':selected').val() == "") {
                $(input).prop('disabled', true);
            }
        }
    });

    if ($('#listCityFilter').val()) {
        $('#listCountryFilter').prop('disabled', true)
    }
});


$('.advanced_search_btn').on('click', function () {
    $(this).toggleClass('active');
});