if ($("#image-carousel").length) {
    const detailSplide = new Splide('#image-carousel', {
        pagination: false,
    });

    detailSplide.on('arrows:updated', function (prev, next, prevIndex, nextIndex) {
        $(".active-image").html(nextIndex == -1 ? $(".total-image").html() : nextIndex);
    });

    detailSplide.mount();
}

if ($("#recommended-carousel").length) {
    const recommendedSplide = new Splide('#recommended-carousel', {
        pagination: false,
    });

    recommendedSplide.on('arrows:updated', function (prev, next, prevIndex, nextIndex) {
        $(".recommended-active-image").html(nextIndex == -1 ? $(".recommended-total-image").html() : nextIndex);
    });

    recommendedSplide.mount();
}

if ($("#mobile-carousel").length) {
    const mobileSplide = new Splide('#mobile-carousel', {
        arrows: false,
        pagination: false,
    });
// Collects LI elements:
    var thumbnails = $('.mobile-thumbnail');
    var current; // Keeps the current thumbnail

    for (var i = 0; i < thumbnails.length; i++) {
        initThumbnail(thumbnails[i], i);
    }

// The function to initialize each thumbnail.
    function initThumbnail(thumbnail, index) {
        $(thumbnail).on('click', function () {
            mobileSplide.go(index);
        });
    }

    mobileSplide.on('move', function () {
        if (current) {
            current.classList.remove('is-active');
        }

        // Splide#index returns the latest slide index:
        var thumbnail = thumbnails[mobileSplide.index];

        if (thumbnail) {
            thumbnail.classList.add('is-active');
            current = thumbnail;
        }
    })

    mobileSplide.mount();

}

if ($("#recommended-mobile-carousel").length) {
    const recommendedSplide = new Splide('#recommended-mobile-carousel', {
        pagination: false,
    });

    recommendedSplide.mount();
}


$(".js-copy-link").on("click", function (e) {
    navigator.clipboard.writeText($(e.currentTarget).data("uri"));
    $(".js-copy-link").popover("show");
    setTimeout(() => {
        $(".js-copy-link").popover("hide");
    }, 1000)
});


if (typeof lat !== 'undefined' && typeof lng !== 'undefined' && typeof google_map_key !== 'undefined') {
    $(document).ready(function () {
        var no_image_text = "{{ trans('visiosoft.module.advs::field.no_street_view') }}";

        var ifAnyImg = "https://maps.googleapis.com/maps/api/streetview/metadata?size=600x300&location=" + lat + "," + lng +
            "&fov=90&heading=235&pitch=10&key=" + google_map_key;
        $.getJSON(ifAnyImg, function (data) {
                if (data.status === "OK") {
                    loadScript(`https://maps.googleapis.com/maps/api/js?key=${google_map_key}&callback=initMap`);
                }
                if (data.status === "ZERO_RESULTS") {
                    $("#mapDiv").html(no_image_text);
                } else {
                    $("#mapDiv").html("Google Error : " + data.error_message);
                }
            }
        )
    });

    function loadScript(src, callback) {
        var script = document.createElement("script");
        script.type = "text/javascript";
        if (callback) script.onload = callback;
        document.getElementsByTagName("head")[0].appendChild(script);
        script.src = src;
    }

    function initMap() {
        var myLatLng = {lat: lat, lng: lng};

        var map = new google.maps.Map(document.getElementById('mapDiv'), {
            zoom: 16,
            center: myLatLng
        });
        new google.maps.Marker({
            position: myLatLng,
            map: map
        });
    }
}