<?php namespace Visiosoft\DressTheme;


use Anomaly\Streams\Platform\Application\Application;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Symfony\Component\Console\Input\ArgvInput;
use Visiosoft\DressTheme\Seed\PagesSeeder;
use Visiosoft\DressTheme\Seed\RepeaterSeeder;
use Visiosoft\DressTheme\Seed\SettingSeeder;


class DressThemeSeeder extends Seeder
{
    public function run()
    {
        $this->call(RepeaterSeeder::class);
        $this->call(PagesSeeder::class);
        $this->call(SettingSeeder::class);
        $application_reference = (new ArgvInput())->getParameterOption('--app', env('APPLICATION_REFERENCE', 'default'));
        // SQL file seeding
        Model::unguard();
        DB::unprepared(str_replace('{application_reference}', $application_reference, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/data/cicekci_repeater.sql')));
        Model::reguard();
        $zip = new \ZipArchive();
        $zip->open(__DIR__ . '/seed/data/cicekci_repeater.zip', \ZipArchive::CREATE);
        $zip->extractTo(storage_path('streams/'.app(Application::class)->getReference().'/files-module/'));
        $zip->close();

        Artisan::call('files:sync');
        Artisan::call('assets:clear');


    }
}
