<?php

return [
    'logo' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    'color' => [
        'type' => "anomaly.field_type.colorpicker",
        "config" => [
            "default_value" => '#51b849',
        ]
    ],
    'address' => [
        'type' => 'anomaly.field_type.textarea',
        "config" => [
            "default_value" => "1223, Main Street, Anytown New York, 38000 USA",
        ]
    ],
    'phone' => [
        'type' => 'anomaly.field_type.text',
        "config" => [
            'type' => 'tel',
            'mask' => '0(999) 999-9999'
        ]
    ],

    'big_image' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    'header_image' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
        ]
    ],
    "header_url" => [
        "type"   => "anomaly.field_type.url",
    ],
    "header_background" => [
        "type"   => "anomaly.field_type.colorpicker",
        "config" => [
            "default_value" => '#61259e',
        ]
    ],
    'default_country' => [
        'type' => 'anomaly.field_type.relationship',
        "config" => [
            "related" => \Visiosoft\LocationModule\Country\CountryModel::class,
            'default_value' => 212,
        ]
    ],

    "favicon" => [
        "type" => "anomaly.field_type.file",
        "config" => [
            "folders" => ['favicon'],
            "mode" => "upload",
        ]
    ],

    "zeroPrice" => [
        "type" => "anomaly.field_type.boolean",
        "config" => [
            "default_value" => true,
        ]
    ],

    "campaign_image" => [
        "type" => "anomaly.field_type.file",
        "config" => [
            "folders" => ['images'],
        ]
    ],

    "campaign_url" => [
        "type" => "anomaly.field_type.text",
    ],

    "homepage_thumbnail_height" => [
        "type" => "anomaly.field_type.integer",
        "config" => [
            "default_value" => 250,
            "min" => 0,
        ]
    ],

    "listing_page_thumbnail_height" => [
        "type" => "anomaly.field_type.integer",
        "config" => [
            "default_value" => 393,
        ]
    ],
    "recommended_ads_title" => [
        "type" => "anomaly.field_type.text",
        "config" => [
            "default_value" => "visiosoft.theme.dress::field.color_select",
        ],
    ],
    'primary_text_color' => [
        'type' => "anomaly.field_type.colorpicker",
        "config" => [
            "default_value" => '#000',
        ]
    ],
    'banner_top_left' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
        ]
    ],
    'banner_top_rTop' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
        ]
    ],
    'banner_top_rBottom' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
        ]
    ],
    'banner_bottom' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
        ]
    ],
    'banner_footer' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
        ]
    ],
];